#include "AudioStack/SMT/clSrcState_SourceAvailableCheck.h"
#include "AudioStack/clAudioSMEngine.h"
#include "AudioStack/clAudioSource.h"
#include "AudioStack/SMT/clSrcStateFactory.h"

namespace AudioStack
{

tVoid clSrcState_SourceAvailableCheck::vEnter(clAudioSource* pclAudioSource, tU32 u32UserData, tU8 enEntryCondition)
{
   vMsg_SrcAvailabilityChg(pclAudioSource, u32UserData);
}

//tVoid clSrcState_SourceAvailableCheck::vMsg_Off(clAudioSource* pclAudioSource, tU32 u32UserData)
//{
//   // simple transition from waitFor to off
//   vSetState(pclAudioSource, clSrcStateFactory::pclCreateOff(), u32UserData, ENTRYCONDITION_NONE);
//}

tVoid clSrcState_SourceAvailableCheck::vMsg_SrcAvailabilityChg(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   if (NULL != pclAudioSource)
   {
      clAudioSource::enSourceAvailability srcAvail = pclAudioSource->enIsSourceAvailable();
      if(srcAvail == clAudioSource::available)
      {
         vHandleTrigger(clSrcState::SrcAvailabilityChg, pclAudioSource, u32UserData);
      }
      if(srcAvail == clAudioSource::not_available)
      {
         clAudioSMEngine::Source_Removed(pclAudioSource->sGetId());
      }
   }
}
}

